<?php
session_start();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>🎤 اتاق چت صوتی</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Tahoma;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            text-align: center;
            width: 100%;
            max-width: 400px;
        }
        
        h1 {
            color: #333;
            margin-bottom: 20px;
            font-size: 28px;
        }
        
        h1 i {
            color: #667eea;
            margin-left: 10px;
        }
        
        input {
            width: 100%;
            padding: 15px;
            margin: 20px 0;
            border: 2px solid #ddd;
            border-radius: 10px;
            font-size: 16px;
            text-align: center;
        }
        
        button {
            background: linear-gradient(45deg, #667eea, #764ba2);
            color: white;
            border: none;
            padding: 15px 30px;
            border-radius: 10px;
            font-size: 18px;
            cursor: pointer;
            width: 100%;
            transition: transform 0.3s;
        }
        
        button:hover {
            transform: translateY(-2px);
        }
        
        .info {
            margin-top: 20px;
            padding: 15px;
            background: #f0f5ff;
            border-radius: 10px;
            color: #667eea;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><i class="fas fa-broadcast-tower"></i> اتاق چت صوتی</h1>
        <p style="color: #666; margin-bottom: 20px;">وارد شو، صحبت کن، همه بشنون!</p>
        
        <input type="text" id="username" placeholder="اسمتو اینجا بنویس..." autocomplete="off" autofocus>
        <button onclick="enterRoom()">ورود به اتاق</button>
        
        <div class="info">
            <i class="fas fa-info-circle"></i> بعد از ورود، میکروفونت فعال میشه. دکمه رو نگه دار و صحبت کن!
        </div>
    </div>

    <script>
        function enterRoom() {
            const username = document.getElementById('username').value.trim();
            if(!username) {
                alert('لطفا یه اسم انتخاب کن');
                return;
            }
            
            // ذخیره در localStorage
            localStorage.setItem('voicechat_username', username);
            
            // انتقال به اتاق
            window.location.href = 'room.php?user=' + encodeURIComponent(username);
        }
        
        // با Enter هم بشه وارد شد
        document.getElementById('username').addEventListener('keypress', function(e) {
            if(e.key === 'Enter') enterRoom();
        });
        
        // اگر قبلا وارد شده بود
        window.onload = function() {
            const savedName = localStorage.getItem('voicechat_username');
            if(savedName) {
                document.getElementById('username').value = savedName;
            }
        };
    </script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
</body>
</html>