<?php
session_start();

// اگر کاربر وارد شده
if(isset($_GET['user'])) {
    $_SESSION['username'] = htmlspecialchars($_GET['user']);
}

// اگر کاربری نیست، برگرد به صفحه ورود
if(!isset($_SESSION['username'])) {
    header('Location: index.php');
    exit;
}

$username = $_SESSION['username'];
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>🎤 <?php echo $username; ?> - اتاق چت صوتی</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="container">
        <!-- هدر -->
        <div class="header">
            <div class="user">
                <div class="avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div>
                    <h3><?php echo $username; ?></h3>
                    <span class="status online">● آنلاین</span>
                </div>
            </div>
            <button class="exit-btn" onclick="exitRoom()">
                <i class="fas fa-sign-out-alt"></i> خروج
            </button>
        </div>
        
        <!-- کاربران آنلاین -->
        <div class="online-box">
            <h3><i class="fas fa-users"></i> افراد داخل اتاق:</h3>
            <div id="online-list">
                <!-- لیست کاربران -->
            </div>
        </div>
        
        <!-- کنترل صحبت -->
        <div class="talk-box">
            <div class="mic-control">
                <button id="mic-btn" class="mic-on" onclick="toggleMic()">
                    <i class="fas fa-microphone"></i>
                    میکروفون روشن
                </button>
            </div>
            
            <div class="talk-btn-container">
                <button id="talk-btn" 
                        onmousedown="startTalking()" 
                        onmouseup="stopTalking()"
                        ontouchstart="startTalking()" 
                        ontouchend="stopTalking()">
                    <i class="fas fa-broadcast-tower"></i>
                    نگه دار و صحبت کن
                </button>
                <p class="hint"><i class="fas fa-lightbulb"></i> مثل بیسیم، دکمه رو نگه دار!</p>
            </div>
        </div>
        
        <!-- نمایش صدا -->
        <div class="sound-box">
            <div class="sound-bar">
                <div class="sound-level" id="sound-level"></div>
            </div>
            <p id="talking-status">آماده برای صحبت...</p>
        </div>
        
        <!-- چت متنی -->
        <div class="chat-box">
            <div class="messages" id="chat-messages">
                <!-- پیام‌ها -->
            </div>
            <div class="chat-input">
                <input type="text" id="message-input" placeholder="یه پیام بنویس...">
                <button onclick="sendMessage()"><i class="fas fa-paper-plane"></i></button>
            </div>
        </div>
    </div>

    <audio id="my-audio" autoplay muted></audio>
    
    <script src="script.js"></script>
</body>
</html>